% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.morthump.r
\name{confint.morthump}
\alias{confint.morthump}
\title{Confidence Intervals for morthump fit}
\usage{
\method{confint}{morthump}(object, parm, level = 0.95, method, iter = 1000,
  ...)
}
\arguments{
\item{object}{the result of a \code{morthump} fit.}

\item{parm}{the parameter for which the confidence intevals are estimated, in this case e0.}

\item{level}{the confidence level required.}

\item{method}{either \code{"chiang"} or \code{"MC"} (see details)}

\item{iter}{number of iterations for the \code{"MC"} method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\describe{
 \item{e0}{life expectancy estimated on the fitted force of mortality.}
 \item{lower}{lower bound for e0.}
 \item{upper}{upper bound for e0.}
 }
}
\description{
Computes confidence intervals for life expectancy, which can be used to assess the statistical significance of the young adult mortality hump.
}
\details{
This summary function applies to a \code{morthump} object, resulting from a call to the \code{morthump} function.
Using the fitted force of mortality and observed exposures, it computes confidence intervals for life expectancy at birth.
This value can then be compared with the number of years of life expectancy lost to the hump, as estimated by the \code{morthump} model, in order to assess whether the latter departs statistically from the stochastic noise.

Two methods are available. When \code{method = "chiang"}, an algebraic solution is used (Chiang 1978).
When \code{method = "MC"}, a Monte-Carlo simulation approach is used (Andreev & Shkolnikov 2010). They usually reach very close results.
}
\references{
Chiang, C. L. (1978). Life table and mortality analysis. World Health Organization.
Andreev, E. M., & Shkolnikov, V. M. (2010). Spreadsheet for calculation of confidence limits for any life table or healthy-life table quantity. Rostock: Max Planck Institute for Demographic Research (MPIDR Technical Report, 5.
Brown, L. D., Cai, T. T., & DasGupta, A. (2001). Interval Estimation for a Binomial Proportion. Statistical Science, 16(2), 101-117.
Eayres, D., & Williams, E. (2004). Evaluation of methodologies for small area life expectancy estimation. Journal of epidemiology and community health, 58(3), 243-249.
Toson, B., & Baker, A. (2003). Life expectancy at birth: methodological options for small populations. National statistics methodological series, 33.
}

