% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.morthump.r
\name{summary.morthump}
\alias{summary.morthump}
\alias{print.summary.morthump}
\title{Summary method for morthump models}
\usage{
\method{summary}{morthump}(object, ...)

\method{print}{summary.morthump}(x, ...)
}
\arguments{
\item{object}{the result of a \code{morthump} fit}

\item{...}{further arguments passed to or from other methods}

\item{x}{an object of class "summary.morthump", usually, a result of a call to summary.morthump}
}
\value{
\describe{
 \item{mhat}{vector containing the fitted age-specific death rates.}
 \item{mhump}{vector containing the fitted age-specific contributions to the hump.}
 \item{pval}{when using a parametric model, this is the p-value associated to the F-test against a model with no hump (\code{hps}). It is formally the probability to reject the superiority of the model with a hump given that there is one, and can be intepreted as the probability that the observed hump only appears as the result of stochastic noise.}
 \item{pdf}{function that returns the value of the probability density function of the hump at a given age. Used to compute the mode.}
 \item{cdf}{function that returns the value of the cumulative density function of the hump at a given age. Used to compute any quantile of the hump, including the median.}
 \item{qtl}{function that returns quantiles of the hump (i.e. ages at which the hump has claimed a given percentage of its deaths).}
 \item{loss}{loss of life expectancy due to the hump.}
 \item{dh}{number of lives lost due to the hump.}
 \item{yll}{years of life lost due to the hump.}
 \item{mode}{modal age at death from the hump}
 \item{median}{median age at death from the hump}
 \item{mean}{mean age at death from the hump}
 \item{sd}{standard deviation for the age at death from the hump}
 \item{par}{parameters of the model (in case of a \code{sse} model, these are the coefficients of the base spline)}
 }
}
\description{
Produces a summary of a fitted morthump model
}
\details{
This summary function applies to a \code{morthump} object, resulting from a call to the \code{morthump} function.
Using the fitted age-specific contributions to the hump, it computes summary measures about the intensity, centrality and dispersion of the hump.

\bold{intensity}

The indensity of the hump is measured in terms of the loss of life expectancy implied by the presence of the hump.
It is defined as the difference between life expectancy computed on the fitted force of mortality (sum of the three components), and life expectancy computed on the hump-free force of mortality.
This difference can be interpreted as the mean years of life lost in the population due to the presence of the hump, or alternatively as the potential gain in life expectancy that could be reached in the absence of the hump.

Other measures of intensity are computed to offer a public health perspective to the presence of the hump.
The years of life lost (YLL), which represents the total number of years that could have been lived by those who died because of the hump.
The number of deaths due to the hump is simply the number of deaths that could have been averted in the absence of the hump.

\bold{centrality}

Three measures of centrality are currently proposed: the modal, median and mean age at death from the hump for each cause. By considering the hump as a density, standard summary measures can be applied to it.
The mode is defined as the age at which is observed the highest number of deaths due to the hump, and is therefore not sensitive to the proportion of deaths recorded at other ages.
The median is defined as the age at which half of the deaths due to the hump have occured. It is more sensitive to the overall shape of the hump, but not as much as the mean.
The mean is defined as the mean age at death for the people who die because of the hump, and is therefore sensitive to the general shape of the hump.
The difference between the mode and the mean can inform on the symetry of the hump, e.g. if the mode is located before the mean this suggests the presence of a flatter hump after the peak.

\bold{dispersion}

Dispersion is measured by the standard deviation of the age at which people die because of the hump.
}
