% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMortalityTrend.R
\name{plotMortalityTrend}
\alias{plotMortalityTrend}
\title{Plot the trends of multiple mortality tables (life tables) in one chart}
\usage{
plotMortalityTrend(data, ..., xlim = NULL, ylim = NULL, xlab = NULL,
  ylab = NULL, title = "", legend.position = c(0.9, 0.9),
  legend.key.width = unit(25, "mm"))
}
\arguments{
\item{data}{First life table to be plotted. Either a \code{data.frame} generated by \code{makeQxDataFrame} or a \code{mortalityTable} object}

\item{...}{Additional life tables to be plotted (if \code{data} is a \code{mortalityTable} object)}

\item{xlim}{X-axis limitatation (as a two-element vector)}

\item{ylim}{Y-axis limitatation (as a two-element vector)}

\item{xlab}{X-axis label (default: "Alter")}

\item{ylab}{Y-axis label (default: "Sterbewahrscheinlichkeit q_x relativ zu ....")}

\item{title}{The plot title}

\item{legend.position}{The position of the legend (default is \code{c(0.9,0.1)})}

\item{legend.key.width}{The keywith of the lines in the  legend (default is \code{unit(25,"mm")})}
}
\description{
\code{plotMortalityTrend} prints the trends of multiple life tables (objects
of child classes of \code{mortalityTable}) in one plot, with a legend showing
the names of the tables.
}
\examples{
# Load the Austrian aunnity data
mortalityTables.load("Austria_Annuities")

# Compare the trends of these tables
plotMortalityTrend(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
    Period = 2002, title = "Trends of Austrian Annuity Tables")
# For tables with a non-constant trend, the Period and YOB can be used to compare
# the age-specific trends that apply to the death probabilities during a given
# period or for a given birth year
plotMortalityTrend(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
    YOB = 1950, title = "Trends of Austrian Annuity Tables for cohort YOB=1950")
plotMortalityTrend(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
    YOB = 2000, title = "Trends of Austrian Annuity Tables for cohort YOB=2000")
plotMortalityTrend(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
   Period = 1999, title = "Trends of Austrian Annuity Tables for Period 2002")
plotMortalityTrend(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
   Period = 2030, title = "Trends of Austrian Annuity Tables for Period 2030")
#' @import scales
}
