% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{writeTex}
\alias{writeTex}
\title{Write Latex file for GUIDE regression Tree}
\usage{
writeTex(mrsobj, file, digits = 3, ...)
}
\arguments{
\item{mrsobj}{MrSGUIDE object}

\item{file}{latex filename}

\item{digits}{digits pass to coefficient}

\item{...}{parameters pass to cat function}
}
\value{
write txt file into disk
}
\description{
Write Latex file for GUIDE regression Tree
}
\examples{

library(MrSGUIDE)
set.seed(1234)

N = 200
np = 3

numX <- matrix(rnorm(N * np), N, np) ## numerical features
gender <- sample(c('Male', 'Female'), N, replace = TRUE)
country <- sample(c('US', 'UK', 'China', 'Japan'), N, replace = TRUE)

z <- sample(c(0, 1), N, replace = TRUE) # Binary treatment assignment

y1 <- numX[, 1] + 1 * z * (gender == 'Female') + rnorm(N)
y2 <- numX[, 2] + 2 * z * (gender == 'Female') + rnorm(N)

train <- data.frame(numX, gender, country, z, y1, y2)
role <- c(rep('n', 3), 'c', 'c', 'r', 'd', 'd')

mrsobj <- MrSFit(dataframe = train, role = role)
\dontshow{.old_wd <- setwd(tempdir())}
writeTex(mrsobj, 'test.tex')
\dontshow{setwd(.old_wd)}

}
