% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probest.R
\name{probest}
\alias{probest}
\title{Stratified Multivariate Kawaguchi Koch Wang  Estimators}
\usage{
probest(ds, resp, grp, str = NULL, covs = NULL, delta = NA, correct = FALSE)
}
\arguments{
\item{ds}{The data frame to be used.}

\item{resp}{The vector of the response manifest variable. There can be more than one variable. It has to be the name of the variable as a character string.}

\item{grp}{The vector of the variable that divides the population into groups. It has to be the name of the variable as a character string.}

\item{str}{The vector of the variable used for the strata. It has to be the name of the variable as a character string.}

\item{covs}{The covariates to be used in the model. It has to be the name of the variable as a character string.}

\item{delta}{Offeset for covariates.}

\item{correct}{Should the variance estimator be corrected as in Chen and Kolassa?}
}
\value{
A list with components b, the vector of adjusted estimates from the method, and Vb, the corresponding estimated covariance matrix.
}
\description{
Function that return the estimators and their variance-covariance matrix calculated with the Kawaguchi - Koch - Wang method.
}
\details{
The function calls a Fortran code to calculate the estimators \code{b} and their variance-covariance matrix \code{Vb}
}
\examples{
# Breast cancer data from the MultNonParam package.
data(sotiriou)
attach(sotiriou)
#First simple plot of the data
plot(AGE,TUMOR_SIZE,pch=(recur+1),main="Age and Tumor Size",
  sub="Breast Cancer Recurrence Data",xlab="Age (years)",
  ylab="Tumor Size",col=c("blue","darkolivegreen"))
legend(31,8,legend=c("Not Recurrent","Recurrent"),
  pch=1:2,col=c("blue","darkolivegreen"))
#AGE and TUMOR_SIZE are the response variables, recur is used for the groups,
#TAMOXIFEN_TREATMENT for the stratum and ELSTON.ELLIS_GRADE is a covariate.
po<-probest(sotiriou,c("AGE","TUMOR_SIZE"),"recur",
  "TAMOXIFEN_TREATMENT","ELSTON.ELLIS_GRADE")
}
\references{
A. Kawaguchi, G. G. Koch and X. Wang (2012), "Stratified Multivariate Mann-Whitney Estimators for the Comparison of Two Treatments with Randomization Based Covariance Adjustment", \emph{Statistics in Biopharmaceutical Research} 3 (2) 217-231.

J. E. Kolassa and Y. Seifu (2013), Nonparametric Multivariate Inference on Shift Parameters, \emph{Academic Radiology} 20 (7), 883-888.
}
