% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CholRestrictionsJLL.R
\name{CholRestrictionsJLL}
\alias{CholRestrictionsJLL}
\title{Impose the zero-restrictions on the Cholesky-factorization from JLL-based models.}
\usage{
CholRestrictionsJLL(SigmaUnres, M, G, N, Economies, DomUnit)
}
\arguments{
\item{SigmaUnres}{unrestricted variance-covariance matrix (K X K)}

\item{M}{number of domestic unspanned factors per country (scalar)}

\item{G}{number of global unspanned factors (scalar)}

\item{N}{number of country-specific spanned factors (scalar)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{DomUnit}{Name of the economy which is assigned as the dominant unit. \cr
If no dominant unit is assigned, then this variable is defined as "none"}
}
\value{
restricted version the Cholesky factorization matrix from JLL-based models (K x K)
}
\description{
Impose the zero-restrictions on the Cholesky-factorization from JLL-based models.
}
\keyword{internal}
