% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOutputs.R
\name{InputsForOutputs}
\alias{InputsForOutputs}
\title{Collect the inputs that are used to construct the numerical and the graphical outputs}
\usage{
InputsForOutputs(
  ModelType,
  Horiz,
  ListOutputWished,
  OutputLabel,
  WishStationarityQ,
  UnitYields,
  WishGraphYields = 0,
  WishGraphRiskFactors = 0,
  WishOrthoJLLgraphs = 0,
  WishForwardPremia = 0,
  LimFP = NULL,
  WishBootstrap = 0,
  ListBoot = NULL,
  WishForecast = 0,
  ListForecast = NULL
)
}
\arguments{
\item{ModelType}{String-vector containing the label of the model to be estimated}

\item{Horiz}{Single numerical vector conataining the desired horizon of analysis for the outputs}

\item{ListOutputWished}{List of desired graphical outputs. Available options are: "Fit","IRF", "FEVD", "GIRF", "GFEVD".}

\item{OutputLabel}{Name of the output label to be stored}

\item{WishStationarityQ}{User must set 1 is she whises to impose the largest eigenvalue under the Q to be strictly
smaller than 1, otherwise set 0.}

\item{UnitYields}{(i) "Month": if maturity of yields are expressed in months or
(ii) "Year": if maturity of yields are expressed in years}

\item{WishGraphYields}{Binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise. Default is set as "0".}

\item{WishGraphRiskFactors}{Binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise. Default is set as "0".}

\item{WishOrthoJLLgraphs}{Binary variable: set 1, if the user wishes orthogonalized JLL-based graphs to be generated; or set 0, otherwise.
Default is set as "0"}

\item{WishForwardPremia}{Binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise. Default is set as "0".}

\item{LimFP}{Numerical vector containing the maturties associated with the starting and the ending date of the loan}

\item{WishBootstrap}{Binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise. Default is set as "0".}

\item{ListBoot}{List containing the four following elements:
\enumerate{
 \item "methodBS": Desired bootstrap method among (a) 'bs' (standard residual bootstrap), (b) 'wild' (wild bootstrap),
                  (c) 'block' (block  bootstrap);
 \item "BlockLength": if block bootstrap is chosen, then the user has to specify the lenght of the block (single numerical vector);
 \item "ndraws": number of draws;
 \item "pctg": level of confidence (single numerical vector expressed in basis points)
}}

\item{WishForecast}{Binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise. Default is set as "0".}

\item{ListForecast}{list containing the three following elements:
\enumerate{
 \item "ForHoriz": forecast horizon;
 \item "t0Sample": index of the first variable of the information set;
 \item "t0Forecast": index of the first forecast cut-off date.
}}
}
\value{
List of necessary inputs to generate the graphs of the outputs of the desired model
}
\description{
Collect the inputs that are used to construct the numerical and the graphical outputs
}
\examples{

ModelType <- "JPS"
Horiz <- 100
DesiredOutputGraphs <- c("Fit", "GIRF", "GFEVD")
OutputLabel <- "Test"
WishStationarityQ <- 1
WishGraphRiskFac <- 0
WishGraphYields <- 1


InputsList <- InputsForOutputs(ModelType, Horiz, DesiredOutputGraphs, OutputLabel,
                              WishStationarityQ, WishGraphYields, WishGraphRiskFac)
}
