% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JLL.R
\name{JLL}
\alias{JLL}
\title{Set of inputs present at JLL's P-dynamics}
\usage{
JLL(NonOrthoFactors, N, JLLinputs)
}
\arguments{
\item{NonOrthoFactors}{Risk factors before the orthogonalization (FxT)}

\item{N}{Number of country-specific spanned factors}

\item{JLLinputs}{List of necessary inputs to estimate JLL outputs:
\enumerate{
    \item Economies:  set of economies that are part of the economic system (string-vector)
    \item "DomUnit": name of the economy which is assigned as the dominant unit. \cr
                If no dominant unit is assigned, then this variable is defined as "None"
    \item WishSigmas: equal to "1" if one wishes the variance-covariance matrices and the Cholesky factorizations
                (can take long if they need to be estimated). Set "0", otherwise.
    \item SigmaNonOrtho: NULL or some F x F matrix from the non-orthogonalized dynamics
    \item JLLModelType: available options are "JLL original", "JLL jointSigma"  or "JLL NoDomUnit"
}}
}
\value{
List of model parameters from both the orthogonalized and non-orthogonalized versions of the JLL's based models
}
\description{
Set of inputs present at JLL's P-dynamics
}
\details{
For the models 'JLL original' or "JLL jointSigma" the name of one dominant economy must assigned.\cr
For the model 'JLL  NoDomUnit', the name of one dominant economy must be set as "None".
}
\examples{
\donttest{
data(CM_Factors)
ZZ <- RiskFactors
N <- 3

JLLinputs <- list()
JLLinputs$Economies <- c( "China", "Brazil", "Mexico", "Uruguay")
JLLinputs$DomUnit <- "China"
JLLinputs$WishSigmas <- 1
JLLinputs$SigmaNonOrtho <- NULL
JLLinputs$JLLModelType <- "JLL original"

JLL(ZZ, N, JLLinputs)

}
}
\references{
Jotiskhatira, Le and Lundblad (2015). "Why do interest rates in different currencies co-move?" (Journal of Financial Economics)
}
