% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEdensity.R
\name{MLEdensity_jointQ}
\alias{MLEdensity_jointQ}
\title{Compute the maximum likelihood function ("joint Q" models)}
\usage{
MLEdensity_jointQ(
  K1XQ,
  r0,
  SSZ,
  K0Z,
  K1Z,
  se,
  Gy.0,
  mat,
  Y,
  Z,
  P,
  Wpca,
  We,
  WpcaFull,
  dt,
  Economies,
  FactorLabels,
  ModelType,
  GVARinputs,
  JLLinputs,
  nargout
)
}
\arguments{
\item{K1XQ}{risk-neutral feedback matrix (NxN)}

\item{r0}{long-run interest rate  (scalar)}

\item{SSZ}{variance-covariance matrix (KxK)}

\item{K0Z}{intercept from the P-dynamics (Kx1)}

\item{K1Z}{feedback matrix from the P-dynamics (KxK)}

\item{se}{Variance of the portfolio of yields observed with error (scalar)}

\item{Gy.0}{matrix of contemporaneous terms from the P-dynamics (KxK)}

\item{mat}{vector of maturities (in years) of yields used in estimation (J x 1)}

\item{Y}{matrix of yields used in estimation  (J x T)}

\item{Z}{complete set of spanned and unspanned factors (KxT)}

\item{P}{complete set of spanned factors (NxT)}

\item{Wpca}{matrix of weights of the portfolios observed without errors (NxJ)}

\item{We}{matrix of weights of the portfolios observed with errors ((J-N)xJ)}

\item{WpcaFull}{composite matrix of weights the portfolios observed with and without errors}

\item{dt}{time interval unit of the model (scalar). For instance, if data is (i) monthly, dt <- 12; (ii) quarterly, dt <- 4; (iii) yearly, dt <- 1.}

\item{Economies}{set of economies that are part of the economic system (vector of text)}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{ModelType}{feasible options are (i) "VAR jointQ", (ii) "GVAR jointQ" or (iii) "JLL jointSigma"}

\item{GVARinputs}{if the model chosen is the "GVAR sepQ", the "GVARinputs" should be specified (see "GVAR" function)}

\item{JLLinputs}{if the model chosen is the "JLL jointSigma". "JLLinputs" should contain (i) DomUnit, (ii) WishSigmas, (iii) SigmaNonOrtho, (iv) JLLModelType (See JLL function)}

\item{nargout}{if nargout== 1: provides only the values of the likelihood; if nargout== 2: complete ATSM outputs}
}
\description{
Compute the maximum likelihood function ("joint Q" models)
}
\references{
This function is an extended version of the "A0N_MLEdensity_WOE" function by Le and Singleton (2018).\cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
\keyword{internal}
