% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{CheckInputsForMLE}
\alias{CheckInputsForMLE}
\title{Check consistence of inputs}
\usage{
CheckInputsForMLE(
  t0,
  tF,
  Economies,
  DomesticMacroFac,
  GlobalMacroFac,
  UnitYields,
  DataFreq,
  Label_Single_Models,
  Label_Multi_Models,
  FactorLabels,
  GVARlist,
  ModelType
)
}
\arguments{
\item{t0}{Sample starting date}

\item{tF}{Sample last date}

\item{Economies}{string-vector containing the names of the economies of the system.}

\item{DomesticMacroFac}{time series of the country-specific macroeconomic risk factors for all C countries (CM x T)}

\item{GlobalMacroFac}{time series of the global macroeconomic risk factors (G x T)}

\item{UnitYields}{(i) "Month": if maturity of yields are expressed in months or
(ii) "Year": if maturity of yields are expressed in years}

\item{DataFreq}{single element character-based vector. Available options are: "Daily All Days", \cr
"Daily Business Days", "Weekly", "Monthly",  "Quarterly", "Annually"}

\item{Label_Single_Models}{string-vector containing the names of the single country setups}

\item{Label_Multi_Models}{string-vector containing the names of the multicountry setups}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{GVARlist}{list of necessary inputs for the estimation of GVAR-based models (see "GVAR" function)}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\description{
Check consistence of inputs
}
\keyword{internal}
