% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{Bootstrap}
\alias{Bootstrap}
\title{Generates the bootstrap-related outputs}
\usage{
Bootstrap(
  ModelType,
  ModelParaPE,
  NumOutPE,
  Economies,
  InputsForOutputs,
  FactorLabels,
  JLLlist,
  GVARlist,
  WishBC,
  BRWlist,
  Folder2save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{ModelParaPE}{A list containing the point estimates of the model parameters. For details, refer to the outputs from the \code{\link{Optimization}} function.}

\item{NumOutPE}{The point estimate derived from numerical outputs. See the outputs from the \code{\link{NumOutputs}} function for further information.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{InputsForOutputs}{A list containing the necessary inputs for generating IRFs, GIRFs, FEVDs, GFEVDs and Term Premia.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{JLLlist}{List. Inputs for JLL model estimation (see \code{\link{JLL}} function). Default is NULL.}

\item{GVARlist}{List. Inputs for GVAR model estimation (see \code{\link{GVAR}} function). Default is NULL.}

\item{WishBC}{Whether to estimate the physical parameter model with bias correction, based on the method by Bauer, Rudebusch and Wu (2012) (see \code{\link{Bias_Correc_VAR}} function). Default is set to 0.}

\item{BRWlist}{List of necessary inputs for performing the bias-corrected estimation (see \code{\link{Bias_Correc_VAR}} function).}

\item{Folder2save}{Folder path where the outputs will be stored. Default option saves the outputs in a temporary directory.}

\item{verbose}{Logical flag controlling function messaging. Default is TRUE.}
}
\value{
An object of class 'ATSMModelBoot' containing the following keys elements:
\itemize{
\item List of model parameters for each draw
\item List of numerical outputs (IRFs, GIRFs, FEVDs and GFEVDs) for each draw
\item Confidence bounds for the chosen level of significance
}
}
\description{
Generates the bootstrap-related outputs
}
\examples{
\donttest{
data("ParaSetEx")
data("InpForOutEx")
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar = "Eco_Act", GlobalVar = "Gl_Eco_Act", Economy, ModelType)

# Adjust Forecasting setting
InpForOutEx[[ModelType]]$Bootstrap <- list(WishBootstrap = 1, methodBS = 'bs', BlockLength = 4,
                                          ndraws = 5, pctg =  95)

Boot <- Bootstrap(ModelType, ModelParaEx, NumOutEx, Economy, InpForOutEx, FacLab, JLLlist = NULL,
                 GVARlist = NULL, WishBC = 0, BRWlist = NULL, Folder2save  = NULL, verbose = TRUE)
}
}
