% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_weights_one_country.R
\name{pca_weights_one_country}
\alias{pca_weights_one_country}
\title{Computes the PCA weights for a single country}
\usage{
pca_weights_one_country(Yields, Economy)
}
\arguments{
\item{Yields}{A matrix of bond yields (J x T) for a single country, where J is the number of maturities and T is the time series length.}

\item{Economy}{A character string indicating the name of the economy.}
}
\value{
A matrix (J x J) that corresponds to the eigenvectors of the variance-covariance matrix of yields
}
\description{
Computes the PCA weights for a single country
}
\examples{
data(CM_Yields)
Economy <- "Mexico"
pca_weights <- pca_weights_one_country(Yields, Economy)

}
