% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiFit.R
\name{permNullTest}
\alias{permNullTest}
\title{Permutation null distribution}
\usage{
permNullTest(perm.null.sim = 10000L, xy, x = x, y = y, fit,
  parts = 4L, save.perm.null = FALSE, perm.null.fname = NULL,
  verbose = FALSE)
}
\arguments{
\item{perm.null.sim}{Positive integer, the number of simulated values to be computed
when a permutation null distribution is simulated.}

\item{xy}{A list, whose first element corresponds to the matrix x as below, and
its second element corresponds to the matrix y as below. If \code{xy} is not
specified, \code{x} and \code{y} need to be assigned.}

\item{x}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{y}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{fit}{An object generated by \code{multiFit}.}

\item{parts}{Positive integer, divide computation to four parts. Useful for getting
a sense of progress (when \code{verbose=TRUE}) or for distributing memory requirement.}

\item{save.perm.null}{Logical, if \code{TRUE}, save the permutation null into an RData
file named \code{perm.null.fname}}

\item{perm.null.fname}{String, file name to which to save an RData file containing
the permutation null if \code{save.perm.null=TRUE}.}

\item{verbose}{Logical.}
}
\description{
Simulate a permutation null distribution (per input data and testing
parameters) for the global test statistics. See vignettes for examples of usage.
}
