% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR.R
\name{CSR_plot}
\alias{CSR_plot}
\title{Create a ternary plot of CSR strategies}
\usage{
CSR_plot(data)
}
\arguments{
\item{data}{A dataframe containing columns C, S, R, and type for CSR strategy values and plant types.}
}
\value{
A ggplot object representing the ternary plot of CSR strategies.
}
\description{
This function creates a ternary plot of Competition-Stress-Ruderal (CSR) strategies using the ggtern package.
}
\details{
The function uses ggtern to create a ternary plot with the following features:
\itemize{
\item Points colored and filled by plant type
\item Axis labels for C, S, and R percentages
\item A white background with RGB colored axes
\item Legend positioned at the bottom
}
}
\examples{
LA <- c(369615.7, 11.8, 55.7, 36061.2, 22391.8, 30068.1, 31059.5, 29895.1)
LDMC <- c(25.2, 39.7, 13.3, 35.5, 33.2, 36.1, 35.2, 34.9)
SLA <- c(17.4, 6.6, 34.1, 14.5, 8.1, 12.1, 9.4, 10.9)
traits <- data.frame(LA, LDMC, SLA)
result <- CSR(data = traits)
CSR_plot(data=result)

}
\references{
\enumerate{
\item Grime, J.P. (1974). Vegetation classification by reference to strategies. Nature, 250, 26–31.
\item Pierce, S., Negreiros, D., Cerabolini, B.E.L., Kattge, J., Díaz, S., et al. (2017). A global method for calculating plant CSR ecological strategies applied across biomes world-wide. Funct Ecol, 31: 444-457.
}
}
