/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public final class PathFilters {
    private static final PathFilter PART_FILE_INSTANCE = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return name.startsWith("part-") && !name.endsWith(".crc");
        }
    };
    private static final PathFilter CLUSTER_FINAL = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return name.startsWith("clusters-") && name.endsWith("-final");
        }
    };
    private static final PathFilter LOGS_CRC_INSTANCE = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.endsWith(".crc") && !name.startsWith(".") && !name.startsWith("_");
        }
    };

    private PathFilters() {
    }

    public static PathFilter partFilter() {
        return PART_FILE_INSTANCE;
    }

    public static PathFilter finalPartFilter() {
        return CLUSTER_FINAL;
    }

    public static PathFilter logsCRCFilter() {
        return LOGS_CRC_INSTANCE;
    }
}

