/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.mahout.common.Pair;

public final class SequenceFileIterator<K extends Writable, V extends Writable>
extends AbstractIterator<Pair<K, V>>
implements Closeable {
    private final SequenceFile.Reader reader;
    private final Configuration conf;
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final boolean noValue;
    private K key = null;
    private V value = null;
    private final boolean reuseKeyValueInstances;

    public SequenceFileIterator(Path path, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        path = path.makeQualified(fs);
        this.reader = new SequenceFile.Reader(fs, path, conf);
        this.conf = conf;
        this.keyClass = this.reader.getKeyClass();
        this.valueClass = this.reader.getValueClass();
        this.noValue = NullWritable.class.equals(this.valueClass);
        this.reuseKeyValueInstances = reuseKeyValueInstances;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void close() {
        this.key = null;
        this.value = null;
        Closeables.closeQuietly((Closeable)this.reader);
        this.endOfData();
    }

    @Override
    protected Pair<K, V> computeNext() {
        if (!this.reuseKeyValueInstances || this.value == null) {
            this.key = (Writable)ReflectionUtils.newInstance(this.keyClass, (Configuration)this.conf);
            if (!this.noValue) {
                this.value = (Writable)ReflectionUtils.newInstance(this.valueClass, (Configuration)this.conf);
            }
        }
        try {
            boolean available = this.noValue ? this.reader.next(this.key) : this.reader.next(this.key, this.value);
            if (!available) {
                this.close();
                return null;
            }
            return new Pair<K, V>(this.key, this.value);
        }
        catch (IOException ioe) {
            this.close();
            throw new IllegalStateException(ioe);
        }
    }
}

