/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.mahout.common.iterator.FileLineIterator;

public final class FileLineIterable
implements Iterable<String> {
    private final InputStream is;
    private final Charset encoding;
    private final boolean skipFirstLine;

    public FileLineIterable(File file) throws IOException {
        this(file, Charsets.UTF_8, false);
    }

    public FileLineIterable(File file, boolean skipFirstLine) throws IOException {
        this(file, Charsets.UTF_8, skipFirstLine);
    }

    public FileLineIterable(File file, Charset encoding, boolean skipFirstLine) throws IOException {
        this(FileLineIterator.getFileInputStream(file), encoding, skipFirstLine);
    }

    public FileLineIterable(InputStream is) {
        this(is, Charsets.UTF_8, false);
    }

    public FileLineIterable(InputStream is, boolean skipFirstLine) {
        this(is, Charsets.UTF_8, skipFirstLine);
    }

    public FileLineIterable(InputStream is, Charset encoding, boolean skipFirstLine) {
        this.is = is;
        this.encoding = encoding;
        this.skipFirstLine = skipFirstLine;
    }

    @Override
    public Iterator<String> iterator() {
        try {
            return new FileLineIterator(this.is, this.encoding, this.skipFirstLine);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

