/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

final class ALSUtils {
    private ALSUtils() {
    }

    static Vector readFirstRow(Path dir, Configuration conf) throws IOException {
        SequenceFileDirValueIterator iterator = new SequenceFileDirValueIterator(dir, PathType.LIST, PathFilters.partFilter(), null, true, conf);
        return iterator.hasNext() ? ((VectorWritable)((Object)iterator.next())).get() : null;
    }

    static OpenIntObjectHashMap<Vector> readMatrixByRows(Path dir, Configuration conf) {
        OpenIntObjectHashMap matrix = new OpenIntObjectHashMap();
        for (Pair pair : new SequenceFileDirIterable(dir, PathType.LIST, PathFilters.partFilter(), conf)) {
            int rowIndex = ((IntWritable)pair.getFirst()).get();
            Vector row = ((VectorWritable)((Object)pair.getSecond())).get().clone();
            matrix.put(rowIndex, (Object)row);
        }
        return matrix;
    }
}

