/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.parameters.ClassParameter;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.common.parameters.Parametered;
import org.apache.mahout.common.parameters.PathParameter;
import org.apache.mahout.math.Algebra;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class MahalanobisDistanceMeasure
implements DistanceMeasure {
    private Matrix inverseCovarianceMatrix;
    private Vector meanVector;
    private ClassParameter vectorClass;
    private ClassParameter matrixClass;
    private List<Parameter<?>> parameters;
    private Parameter<Path> inverseCovarianceFile;
    private Parameter<Path> meanVectorFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Configuration jobConf) {
        block13: {
            if (this.parameters == null) {
                Parametered.ParameteredGeneralizations.configureParameters(this, jobConf);
            }
            try {
                FSDataInputStream in;
                FileSystem fs;
                if (this.inverseCovarianceFile.get() != null) {
                    fs = FileSystem.get((URI)this.inverseCovarianceFile.get().toUri(), (Configuration)jobConf);
                    MatrixWritable inverseCovarianceMatrix = ClassUtils.instantiateAs((Class)this.matrixClass.get(), MatrixWritable.class);
                    if (!fs.exists(this.inverseCovarianceFile.get())) {
                        throw new FileNotFoundException(this.inverseCovarianceFile.get().toString());
                    }
                    in = fs.open(this.inverseCovarianceFile.get());
                    try {
                        inverseCovarianceMatrix.readFields((DataInput)in);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)in);
                    }
                    this.inverseCovarianceMatrix = inverseCovarianceMatrix.get();
                    Preconditions.checkArgument(this.inverseCovarianceMatrix != null, "inverseCovarianceMatrix not initialized");
                }
                if (this.meanVectorFile.get() == null) break block13;
                fs = FileSystem.get((URI)this.meanVectorFile.get().toUri(), (Configuration)jobConf);
                VectorWritable meanVector = ClassUtils.instantiateAs((Class)this.vectorClass.get(), VectorWritable.class);
                if (!fs.exists(this.meanVectorFile.get())) {
                    throw new FileNotFoundException(this.meanVectorFile.get().toString());
                }
                in = fs.open(this.meanVectorFile.get());
                try {
                    meanVector.readFields((DataInput)in);
                }
                finally {
                    Closeables.closeQuietly((Closeable)in);
                }
                this.meanVector = meanVector.get();
                Preconditions.checkArgument(this.meanVector != null, "meanVector not initialized");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
        this.parameters = Lists.newArrayList();
        this.inverseCovarianceFile = new PathParameter(prefix, "inverseCovarianceFile", jobConf, null, "Path on DFS to a file containing the inverse covariance matrix.");
        this.parameters.add(this.inverseCovarianceFile);
        this.matrixClass = new ClassParameter(prefix, "maxtrixClass", jobConf, DenseMatrix.class, "Class<Matix> file specified in parameter inverseCovarianceFile has been serialized with.");
        this.parameters.add(this.matrixClass);
        this.meanVectorFile = new PathParameter(prefix, "meanVectorFile", jobConf, null, "Path on DFS to a file containing the mean Vector.");
        this.parameters.add(this.meanVectorFile);
        this.vectorClass = new ClassParameter(prefix, "vectorClass", jobConf, DenseVector.class, "Class file specified in parameter meanVectorFile has been serialized with.");
        this.parameters.add(this.vectorClass);
    }

    public double distance(Vector v) {
        return Math.sqrt(v.minus(this.meanVector).dot(Algebra.mult((Matrix)this.inverseCovarianceMatrix, (Vector)v.minus(this.meanVector))));
    }

    @Override
    public double distance(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new CardinalityException(v1.size(), v2.size());
        }
        if (this.inverseCovarianceMatrix == null) {
            System.out.println();
        }
        return Math.sqrt(v1.minus(v2).dot(Algebra.mult((Matrix)this.inverseCovarianceMatrix, (Vector)v1.minus(v2))));
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }

    public void setInverseCovarianceMatrix(Matrix inverseCovarianceMatrix) {
        Preconditions.checkArgument(inverseCovarianceMatrix != null, "inverseCovarianceMatrix not initialized");
        this.inverseCovarianceMatrix = inverseCovarianceMatrix;
    }

    public void setCovarianceMatrix(Matrix m) {
        if (m.numRows() != m.numCols()) {
            throw new CardinalityException(m.numRows(), m.numCols());
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(m);
        Matrix sInv = svd.getS();
        for (int i = 0; i < sInv.numRows(); ++i) {
            double diagElem = sInv.get(i, i);
            if (!(diagElem > 0.0)) {
                throw new IllegalStateException("Eigen Value equals to 0 found.");
            }
            sInv.set(i, i, 1.0 / diagElem);
        }
        this.inverseCovarianceMatrix = svd.getU().times(sInv.times(svd.getU().transpose()));
        Preconditions.checkArgument(this.inverseCovarianceMatrix != null, "inverseCovarianceMatrix not initialized");
    }

    public Matrix getInverseCovarianceMatrix() {
        return this.inverseCovarianceMatrix;
    }

    public void setMeanVector(Vector meanVector) {
        Preconditions.checkArgument(meanVector != null, "meanVector not initialized");
        this.meanVector = meanVector;
    }

    public Vector getMeanVector() {
        return this.meanVector;
    }
}

