/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.mahout.cf.taste.recommender.IDRescorer;

public final class MultiRescorer
implements IDRescorer {
    private final IDRescorer[] rescorers;

    public MultiRescorer(List<IDRescorer> rescorers) {
        Preconditions.checkNotNull(rescorers);
        Preconditions.checkState(!rescorers.isEmpty(), "rescorers is empty");
        this.rescorers = rescorers.toArray(new IDRescorer[rescorers.size()]);
    }

    @Override
    public double rescore(long itemID, double value) {
        for (IDRescorer rescorer : this.rescorers) {
            if (!Double.isNaN(value = rescorer.rescore(itemID, value))) continue;
            return Double.NaN;
        }
        return value;
    }

    @Override
    public boolean isFiltered(long itemID) {
        for (IDRescorer rescorer : this.rescorers) {
            if (!rescorer.isFiltered(itemID)) continue;
            return true;
        }
        return false;
    }
}

