/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.myrrix.common.LangUtils;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.IOUtils;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.IDCluster;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenerationSerializer
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GenerationSerializer.class);
    private static final long serialVersionUID = 1L;
    private static final int NULL_COUNT = -1;
    private Generation generation;

    public GenerationSerializer() {
        this(null);
    }

    public GenerationSerializer(Generation generation) {
        this.generation = generation;
    }

    public Generation getGeneration() {
        return this.generation;
    }

    public static Generation readGeneration(File f) throws IOException {
        return IOUtils.readObjectFromFile(f, GenerationSerializer.class).getGeneration();
    }

    public static void writeGeneration(Generation generation, File f) throws IOException {
        IOUtils.writeObjectToFile(f, new GenerationSerializer(generation));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        FastByIDMap<FastIDSet> knownItemIDs = this.generation.getKnownItemIDs();
        GenerationSerializer.writeKnownIDs(out, knownItemIDs);
        GenerationSerializer.writeMatrix(this.generation.getX(), out);
        GenerationSerializer.writeMatrix(this.generation.getY(), out);
        GenerationSerializer.writeIDSet(this.generation.getItemTagIDs(), out);
        GenerationSerializer.writeIDSet(this.generation.getUserTagIDs(), out);
        GenerationSerializer.writeClusters(this.generation.getUserClusters(), out);
        GenerationSerializer.writeClusters(this.generation.getItemClusters(), out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            FastByIDMap<FastIDSet> newKnownItemIDs = GenerationSerializer.readKnownIDs(in);
            FastByIDMap<float[]> newX = GenerationSerializer.readMatrix(in);
            FastByIDMap<float[]> newY = GenerationSerializer.readMatrix(in);
            FastIDSet itemTagIDs = GenerationSerializer.readIDSet(in);
            FastIDSet userTagIDs = GenerationSerializer.readIDSet(in);
            List<IDCluster> userClusters = GenerationSerializer.readClusters(in);
            List<IDCluster> itemClusters = GenerationSerializer.readClusters(in);
            this.generation = new Generation(newKnownItemIDs, newX, newY, itemTagIDs, userTagIDs, userClusters, itemClusters);
        }
        catch (IOException ioe) {
            log.error("Can't read model. If you have recently upgraded versions, delete the model file and try again");
            throw ioe;
        }
    }

    private static FastByIDMap<FastIDSet> readKnownIDs(ObjectInputStream in) throws IOException {
        int knownItemIDsCount = in.readInt();
        if (knownItemIDsCount == -1) {
            return null;
        }
        FastByIDMap<FastIDSet> newKnownItemIDs = new FastByIDMap<FastIDSet>(knownItemIDsCount, 1.25f);
        for (int i = 0; i < knownItemIDsCount; ++i) {
            long id = in.readLong();
            int setCount = in.readInt();
            FastIDSet set = new FastIDSet(setCount, 1.25f);
            for (int j = 0; j < setCount; ++j) {
                set.add(in.readLong());
            }
            newKnownItemIDs.put(id, set);
        }
        return newKnownItemIDs;
    }

    private static void writeKnownIDs(ObjectOutputStream out, FastByIDMap<FastIDSet> knownItemIDs) throws IOException {
        if (knownItemIDs == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(knownItemIDs.size());
            for (FastByIDMap.MapEntry<FastIDSet> entry : knownItemIDs.entrySet()) {
                out.writeLong(entry.getKey());
                FastIDSet itemIDs = entry.getValue();
                out.writeInt(itemIDs.size());
                LongPrimitiveIterator it = itemIDs.iterator();
                while (it.hasNext()) {
                    out.writeLong(it.nextLong());
                }
            }
        }
    }

    private static FastByIDMap<float[]> readMatrix(ObjectInputStream in) throws IOException {
        int count = in.readInt();
        FastByIDMap<float[]> matrix = new FastByIDMap<float[]>(count, 1.25f);
        for (int i = 0; i < count; ++i) {
            long id = in.readLong();
            float[] features = new float[in.readInt()];
            for (int j = 0; j < features.length; ++j) {
                float f = in.readFloat();
                Preconditions.checkState(LangUtils.isFinite(f));
                features[j] = f;
            }
            matrix.put(id, features);
        }
        return matrix;
    }

    private static void writeMatrix(FastByIDMap<float[]> matrix, ObjectOutputStream out) throws IOException {
        if (matrix == null) {
            out.writeInt(0);
        } else {
            out.writeInt(matrix.size());
            for (FastByIDMap.MapEntry<float[]> entry : matrix.entrySet()) {
                out.writeLong(entry.getKey());
                float[] features = entry.getValue();
                out.writeInt(features.length);
                for (float f : features) {
                    Preconditions.checkState(LangUtils.isFinite(f));
                    out.writeFloat(f);
                }
            }
        }
    }

    private static FastIDSet readIDSet(ObjectInputStream in) throws IOException {
        int count = in.readInt();
        FastIDSet ids = new FastIDSet(count, 1.25f);
        for (int i = 0; i < count; ++i) {
            ids.add(in.readLong());
        }
        return ids;
    }

    private static void writeIDSet(FastIDSet ids, ObjectOutputStream out) throws IOException {
        if (ids == null) {
            out.writeInt(0);
        } else {
            out.writeInt(ids.size());
            LongPrimitiveIterator it = ids.iterator();
            while (it.hasNext()) {
                out.writeLong(it.nextLong());
            }
        }
    }

    private static List<IDCluster> readClusters(ObjectInputStream in) throws IOException {
        int count = in.readInt();
        ArrayList<IDCluster> clusters = Lists.newArrayListWithCapacity(count);
        for (int i = 0; i < count; ++i) {
            int membersSize = in.readInt();
            FastIDSet members = new FastIDSet(membersSize);
            for (int j = 0; j < membersSize; ++j) {
                members.add(in.readLong());
            }
            int centroidSize = in.readInt();
            float[] centroid = new float[centroidSize];
            for (int j = 0; j < centroidSize; ++j) {
                centroid[j] = in.readFloat();
            }
            clusters.add(new IDCluster(members, centroid));
        }
        return clusters;
    }

    private static void writeClusters(Collection<IDCluster> clusters, ObjectOutputStream out) throws IOException {
        if (clusters == null) {
            out.writeInt(0);
        } else {
            out.writeInt(clusters.size());
            for (IDCluster cluster : clusters) {
                FastIDSet members = cluster.getMembers();
                out.writeInt(members.size());
                LongPrimitiveIterator it = members.iterator();
                while (it.hasNext()) {
                    out.writeLong(it.nextLong());
                }
                float[] centroid = cluster.getCentroid();
                out.writeInt(centroid.length);
                for (float f : centroid) {
                    out.writeFloat(f);
                }
            }
        }
    }
}

