% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render a HTML report of a "nacho" object}
\usage{
render(
  nacho_object,
  colour = "CartridgeID",
  output_file = "NACHO_QC.html",
  output_dir = ".",
  size = 1,
  show_legend = TRUE,
  show_outliers = TRUE,
  outliers_factor = 1,
  outliers_labels = NULL,
  clean = TRUE
)
}
\arguments{
\item{nacho_object}{[\link{list}] A list object of class \code{"nacho"} obtained
from \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}

\item{colour}{[\link{character}] Character string of the column in \code{ssheet_csv}
or more generally in \code{nacho_object$nacho} to be used as grouping colour.}

\item{output_file}{[\link{character}] The name of the output file.}

\item{output_dir}{[\link{character}] The output directory for the rendered output_file.
This allows for a choice of an alternate directory to which the output file should be written
(the default output directory is the working directory, \emph{i.e.}, \code{.}).
If a path is provided with a filename in \code{output_file} the directory specified here will take precedence.
Please note that any directory path provided will create any necessary directories if they do not exist.}

\item{size}{[\link{numeric}] A numeric controlling point size
(\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} or #' \code{\link[ggbeeswarm:geom_beeswarm]{ggbeeswarm::geom_beeswarm()}})
or line size (\code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}).}

\item{show_legend}{[\link{logical}] Boolean to indicate whether the plot legends should
be plotted (\code{TRUE}) or not (\code{FALSE}). Default is \code{TRUE}.}

\item{show_outliers}{[\link{logical}] Boolean to indicate whether the outliers should be highlighted
in red (\code{TRUE}) or not (\code{FALSE}). Default is \code{TRUE}.}

\item{outliers_factor}{[\link{numeric}] Size factor for outliers compared to \code{size}. Default is \code{1}.}

\item{outliers_labels}{[\link{character}] Character to indicate which column in \code{nacho_object$nacho}
should be used to be printed as the labels for outliers or not. Default is \code{NULL}.}

\item{clean}{[\link{logical}] Boolean to indicate whether the Rmd and Rdata file used to produce the HTML report
are removed from \code{output_dir}. Default is \code{TRUE}.}
}
\description{
This function create a Rmarkdown script and render it as a HTML document.
The HTML document is a quality-control report using all the metrics from \code{\link[=visualise]{visualise()}}
based on recommendations from NanoString.
}
\examples{

if (interactive()) {
  data(GSE74821)
  render(GSE74821)
}

}
