% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missMDA.reuse.R
\name{missMDA.reuse}
\alias{missMDA.reuse}
\title{missMDA.reuse}
\usage{
missMDA.reuse(
  train_data,
  new_data,
  col_type = NULL,
  ncp,
  random.seed = NULL,
  maxiter = 998,
  coeff.ridge = 1,
  threshold = 1e-06,
  method = "Regularized",
  MFA = FALSE,
  MFA_Object = NULL
)
}
\arguments{
\item{train_data}{data.frame used for treining.}

\item{new_data}{data.frame. Df to impute with column names and without target column.}

\item{col_type}{character vector. Vector containing column type names.}

\item{ncp}{return when the training data set was imputed.}

\item{random.seed}{Integer, by default random.seed = NULL implies that missing values are initially imputed by the mean of each variable. Other values leads to a random initialization}

\item{maxiter}{maximal number of iteration in algortihm.}

\item{coeff.ridge}{Value use in Regularized method.}

\item{threshold}{threshold for convergence.}

\item{method}{method used in imputation algoritm.}

\item{MFA}{If TRUE MFA is used if not MCA, PCA, or FMAD algorithm.}

\item{MFA_Object}{Object produce by missMDA_MFA required to perform MFA imputation.}
}
\description{
The function allows the user access to missMDA imputation in the A approach.
}
\details{
Function use the same trick as in mice.reuse (new data are changed in NA in imputation stage and added back after it ). Because in missMDA is impossible to completely ignore new rows. We set their weights on 1e-300 when weights in the training set equal 1.
}
