% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{list.functions.in.file}
\alias{list.functions.in.file}
\title{Show all functions used in an R script file, by package}
\usage{
list.functions.in.file(filename, alphabetic = TRUE)
}
\arguments{
\item{filename}{path to an R file containing R code.}

\item{alphabetic}{logical, whether to list functions alphabetically.
If FALSE, will list in order of appearance.}
}
\value{
Returns a list. Parses all functions called by an R script
and then lists them by package. Those from the script itself are listed
under '.GlobalEnv' and any functions that may originate
from multiple packages have all possibilities listed. Those listed under
'character(0)' are those for which a package could not be found- may be
functions within functions, or from packages that aren't loaded.
}
\description{
Parses all functions called by an R script and then lists
them by package. Wrapper for 'getParseData'. Inspired by
'hrbrmstr', on StackExchange 3/1/2015. May be of great
use for those developing a package to help see what
namespace 'importsFrom' calls will be required.
}
\examples{
# not run:  rfile <- file.choose() # choose an R script file with functions
# not run:  list.functions.in.file(rfile)
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Rfile.index}}
}

