% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope_conversions.R
\name{calculate_13CO2}
\alias{calculate_13CO2}
\title{Calculate 13C-CO2 Mole Fractions}
\usage{
calculate_13CO2(total_co2, delta13c, f = 0.00474)
}
\arguments{
\item{total_co2}{Vector of CO2 mole fractions.}

\item{delta13c}{Vector of d13C values.}

\item{f}{Fraction of CO2 that is not 12CO2 or 13CO2. Assumed fixed
at 0.00474}
}
\value{
Vector of 13CO2 mole fractions.
}
\description{
This function calculates mole fractions of 13CO2 based on the total CO2 mole
fraction, the delta13C value of the mixture, and the assumed fraction of CO2
that does not correspond to 12CO2 or 13CO2 (assumed fixed at 0.00474, e.g.,
Griffis et al. 2004 Agricultural and Frest Meteorology)
}
\examples{
calculate_13CO2(total_co2 = 410, delta13c = -8.5)

}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
