% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-cluster.R
\name{plotCluster}
\alias{plotCluster}
\title{Plot the clusters in one projection of the bipartite graph.}
\usage{
plotCluster(graph, cluster, ...)
}
\arguments{
\item{graph}{A igraph graph object.}

\item{cluster}{A igraph cluster object, usually got from \code{\link{findCluster}}}

\item{...}{Pass to \code{\link[networkD3]{forceNetwork}}}
}
\value{
A networkD3 object, the plot of cluster.
}
\description{
This function will visualize the input igraph cluster objects
and igraph graph objects with membership properties. Different memberships
will be represented by dots of different colors.
}
\examples{
# generate a incidence matrix
data <- matrix(c(0, 1, 0, 1, 0,
1, 0, 0, 0, 0,
1, 0, 1, 1, 1), nrow = 3,byrow = TRUE)
colnames(data) <- letters[1:5]
rownames(data) <- LETTERS[1:3]

# run findCluster() to do clustering
cls <- findCluster(
  data,
  dim = 1,
  method = "all",
  normalization = FALSE,
  rm_weak_edges = FALSE,
  comparison = FALSE
)
# plot the cluster
plotCluster(graph = cls$graph, cluster = cls$louvain)
}
\seealso{
\code{\link[networkD3]{forceNetwork}}
}
