% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMRphasing.R
\name{NMRphasing}
\alias{NMRphasing}
\title{NMRphasing}
\usage{
NMRphasing(
  specDatIn,
  absorptionOnly = FALSE,
  method = c("NLS", "MPC_DANM", "MPC_EMP", "MPC_AAM", "MPC_DSM", "SPC_DANM", "SPC_EMP",
    "SPC_AAM", "SPC_DSM")
)
}
\arguments{
\item{specDatIn}{Input spectrum data, which can be one of the four formats:
a vector of absorption spectrum; a complex vector; a data matrix or a data frame with two columns of spectrum data,
which 1st column is for absorption spectrum, and 2nd column is for dispersion spectrum}

\item{absorptionOnly}{A logical variable to tell us if specDatIn is a a vector of absorption specrtrum, default is false}

\item{method}{One of phase correction and baseline correction methods. There are nine available choices, which are "NLS", "MPC_DAOM", "MPC_EMP", "MPC_AAM", "MPC_DSM", "SPC_DAOM", "SPC_EMP", "SPC_AAM", "SPC_DSM",
with "NLS", non-linear shrinkage as default.}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
Phase error correction wrap up function
}
\details{
This is a wrap function to process phase error correction and baseline correction with nine different choices.
}
\examples{
data("fdat")
nls_phased <- NMRphasing(specDatIn = fdat$frequency_domain, method = "NLS")
}
\references{
Binczyk F, Tarnawski R, Polanska J (2015) Strategies for optimizing the phase correction algorithms in Nuclear Magnetic Resonance spectroscopy. Biomed Eng Online 14 Suppl 2:S5.

Chen L, Weng Z, Goh L, Garland M (2002) An efficient algorithm for automatic phase correction of NMR spectra based on entropy minimization. J Magn Reson 158:164–168.

de Brouwer H (2009) Evaluation of algorithms for automated phase correction of NMR spectra. J Magn Reson 201:230–238.

Džakula Ž (2000) Phase Angle Measurement from Peak Areas (PAMPAS). J Magn Reson 146:20–32.

Ernst RR (1969) Numerical Hilbert transform and automatic phase correction in magnetic resonance spectroscopy. J Magn Reson 1969 1:7–26.

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase error correction}
