% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMproject-options.R
\name{system_nm}
\alias{system_nm}
\title{System command for NONMEM execution}
\usage{
system_nm(cmd, dir = nm_dir("models"), ...)
}
\arguments{
\item{cmd}{Character. System call to be sent to the terminal.}

\item{dir}{Character. Directory (relative path) to run command in.  By
default this will be the "models" directory (\code{nm_dir("models")}).}

\item{...}{Additional arguments to be passed to \code{system()} or \code{shell()}.}
}
\value{
The return value of \code{getOption("system_nm")}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Not intended to be used directly in most cases.  This is the function used by
\code{run_nm()}.  It can also be used directly to launch other PsN commands like
\code{sumo}.
}
\examples{

system_nm("hostname")

## requires NONMEM to be installed
\dontrun{

system_nm("psn --versions")
system_nm("sumo run1.mod")
}

}
\seealso{
\code{\link[=run_nm]{run_nm()}}
}
