% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMcreateMatLines.R
\name{NMcreateMatLines}
\alias{NMcreateMatLines}
\title{Create text lines for OMEGA and SIGMA Nonmem sections}
\usage{
NMcreateMatLines(omegas, as.one.block = FALSE, fix = FALSE, type)
}
\arguments{
\item{omegas}{A data.table with at least `i`, `j` and `value`
columns. See `NMdata::NMreadExt` and the pars element returned
by that function. Must at least have columns `i`, `j`,
`value`, `iblock`, `blocksize`, `FIX`.}

\item{as.one.block}{If `TRUE`, all values are printed as one
block. If `FALSE` (default), matrix will be separeted into
blocks based on position non-zero off-diagonal
values. Generally speaking, for `OMEGA` matrices (var-cov
matrices for ETAs), this should be `FALSE`, and for
variance-covariance matrices (like `THETAP`), this should be
`TRUE`.}

\item{fix}{Include `FIX` for all lines? If `FALSE`, fixing will
not be modified. Notice, `fix=TRUE` will fix everything -
individual parameters cannot be controlled. For finer control
and way more features, see `NMdata::NMwriteInits()`.}

\item{type}{The matrix type. `OMEGA` or `SIGMA` - case
in-sensitive. Will be used to print say `$OMEGA` in front of
each line.}
}
\value{
Character vector
}
\description{
Create text lines for OMEGA and SIGMA Nonmem sections
}
\keyword{internal}
