% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD_Efficient_Set.R
\name{NNS.SD.Efficient.Set}
\alias{NNS.SD.Efficient.Set}
\title{NNS SD Efficient Set}
\usage{
NNS.SD.Efficient.Set(x, degree)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{degree}{numeric options: (1,2,3); Degree of stochastic dominance test from (1,2 or 3).}
}
\value{
Returns set of stochastic dominant variable names.
}
\description{
Determines the set of stochastic dominant variables for various degrees.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100); z<-rnorm(100)
x<-data.frame(x,y,z)
NNS.SD.Efficient.Set(x,1)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126. \url{http://www.scirp.org/Journal/PaperInformation.aspx?PaperID=63817}.
}
\keyword{dominance}
\keyword{stochastic}

