% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNS_MC.R
\name{NNS.MC}
\alias{NNS.MC}
\title{NNS Monte Carlo Sampling}
\usage{
NNS.MC(
  x,
  reps = 30,
  lower_rho = -1,
  upper_rho = 1,
  by = 0.01,
  exp = 1,
  type = "spearman",
  drift = TRUE,
  target_drift = NULL,
  target_drift_scale = NULL,
  xmin = NULL,
  xmax = NULL,
  ...
)
}
\arguments{
\item{x}{vector of data.}

\item{reps}{numeric; number of replicates to generate, \code{30} default.}

\item{lower_rho}{numeric \code{[-1,1]}; \code{.01} default will set the \code{from} argument in \code{seq(from, to, by)}.}

\item{upper_rho}{numeric \code{[-1,1]}; \code{.01} default will set the \code{to} argument in \code{seq(from, to, by)}.}

\item{by}{numeric; \code{.01} default will set the \code{by} argument in \code{seq(-1, 1, step)}.}

\item{exp}{numeric; \code{1} default will exponentially weight maximum rho value if \code{exp > 1}.  Shrinks values towards \code{upper_rho}.}

\item{type}{options("spearman", "pearson", "NNScor", "NNSdep"); \code{type = "spearman"}(default) dependence metric desired.}

\item{drift}{logical; \code{drift = TRUE} (default) preserves the drift of the original series.}

\item{target_drift}{numerical; \code{target_drift = NULL} (default) Specifies the desired drift when \code{drift = TRUE}, i.e. a risk-free rate of return.}

\item{target_drift_scale}{numerical; instead of calculating a \code{target_drift}, provide a scalar to the existing drift when \code{drift = TRUE}.}

\item{xmin}{numeric; the lower limit for the left tail.}

\item{xmax}{numeric; the upper limit for the right tail.}

\item{...}{possible additional arguments to be passed to \link{NNS.meboot}.}
}
\value{
\itemize{
  \item{ensemble} average observation over all replicates as a vector.
  \item{replicates} maximum entropy bootstrap replicates as a list for each \code{rho}.
}
}
\description{
Monte Carlo sampling from the maximum entropy bootstrap routine \link{NNS.meboot}, ensuring the replicates are sampled from the full [-1,1] correlation space.
}
\examples{
\dontrun{
# To generate a set of MC sampled time-series to AirPassengers
MC_samples <- NNS.MC(AirPassengers, reps = 10, lower_rho = -1, upper_rho = 1, by = .5, xmin = 0)
}
}
\references{
Vinod, H.D. and Viole, F. (2020) Arbitrary Spearman's Rank Correlations in Maximum Entropy Bootstrap and Improved Monte Carlo Simulations.  \doi{10.2139/ssrn.3621614}
}
