% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvsnlikC}
\alias{mvsnlikC}
\title{C++ implementation of multivariate skew normal likelihood function for multiple inputs}
\usage{
mvsnlikC(x, c, clustval, xi, psi, sigma, loglik = TRUE)
}
\arguments{
\item{x}{data matrix of dimension p x n, p being the dimension of the
data and n the number of data points}

\item{c}{integer vector of cluster allocations with values from 1 to K}

\item{clustval}{vector of unique values from c in the order corresponding to
the storage of cluster parameters in \code{xi}, \code{psi}, and \code{sigma}}

\item{xi}{mean vectors matrix of dimension p x K, K being the number of
clusters}

\item{psi}{skew parameter vectors matrix of dimension \code{p x K}}

\item{sigma}{list of length \code{K} of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{loglik}{logical flag or returning the log-likelihood intead of the likelihood.
Default is \code{TRUE}.}
}
\value{
a list:
\itemize{
\item{\code{"indiv"}:}{ vector of likelihood of length n;}
\item{\code{"clust"}:}{ vector of likelihood of length K;}
\item{\code{"total"}:}{ total (log)-likelihood;}
}
}
\description{
C++ implementation of multivariate skew normal likelihood function for multiple inputs
}
\author{
Boris Hejblum
}

