% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmvsnpdfC}
\alias{mmvsnpdfC}
\title{C++ implementation of multivariate skew Normal probability density function for multiple inputs}
\usage{
mmvsnpdfC(x, xi, psi, sigma, Log = TRUE)
}
\arguments{
\item{x}{data matrix of dimension \code{p x n}, \code{p} being the dimension of the
data and n the number of data points.}

\item{xi}{mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
distributions for which the density probability has to be evaluated.}

\item{psi}{skew parameter vectors matrix of dimension \code{p x K}.}

\item{sigma}{list of length K of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{Log}{logical flag for returning the log of the probability density
function. Default is \code{TRUE}.}
}
\value{
matrix of densities of dimension \code{K x n}.
}
\description{
C++ implementation of multivariate skew Normal probability density function for multiple inputs
}
\examples{
mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
         xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)), Log=FALSE
         )
mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
         xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2))
         )

if(require(microbenchmark)){
library(microbenchmark)
microbenchmark(mvsnpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1), xi=c(0, 0), psi=c(1, 1),
                       sigma=diag(2), Log=FALSE),
               mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1), xi=matrix(c(0, 0)),
                         psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)), Log=FALSE),
               times=1000L
             )
microbenchmark(mvsnpdf(x=matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
                      xi=list(c(0,0),c(-1,-1), c(1.5,1.5)),
                      psi=list(c(0.1,0.1),c(-0.1,-1), c(0.5,-1.5)),
                      sigma=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
               mmvsnpdfC(matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
                         xi=matrix(c(0,0,-1,-1, 1.5,1.5), nrow=2, ncol=3),
                         psi=matrix(c(0.1,0.1,-0.1,-1, 0.5,-1.5), nrow=2, ncol=3),
                         sigma=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
              times=1000L)
}else{
cat("package 'microbenchmark' not available\n")
}
}
\author{
Boris Hejblum
}
