% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Download Statistical Data from the API opendata.1212.mn}
\usage{
get_table(tbl_id, PERIOD = NULL, CODE = NULL, CODE1 = NULL,
  CODE2 = NULL)
}
\arguments{
\item{tbl_id}{character string, Table identification number}

\item{PERIOD}{charcter vector, Time}

\item{CODE}{charcter vector, Classification code (age, gender etc)}

\item{CODE1}{charcter vector, Classification code (age, gender etc)}

\item{CODE2}{charcter vector, Classification code (age, gender etc)}
}
\value{
data frame, Statistical data. It has following structure:
\describe{
 \item{TBL_ID}{Row number}
 \item{Period}{Time}
 \item{CODE}{Classification code}
 \item{SCR_MN}{Classification name in Mongolian}
 \item{SCR_ENG}{Classification name in English}
 \item{CODE1}{Classification code}
 \item{SCR_MN1}{Classification name in Mongolian}
 \item{SCR_ENG1}{Classification name in English}
 \item{CODE2}{Classification code}
 \item{SCR_MN2}{Classification name in Mongolian}
 \item{SCR_ENG2}{Classification name in English}
 \item{DTVAL_CO}{Data value}
}
}
\description{
It downloads a table, which contains statistical data, from the API \url{opendata.1212.mn} is supported by National Statistical Office of Mongolia (NSO).
}
\examples{
nso.data <- get_table(
  tbl_id = "DT_NSO_2400_015V2",
  PERIOD = c("201711", "201712", "201801"),
  CODE = c("10", "11"),
  CODE1 = "11"
)
print(nso.data)
}
\references{
\url{http://opendata.1212.mn/en/doc/Api/POST-api-Data}
}
\seealso{
\link{all_tables}, \link{get_table_info}, \link{get_sector_info}
}
