% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{backtest}
\alias{backtest}
\title{Backtest}
\usage{
backtest(m1, rt, orig, h, xre = NULL, fixed = NULL,
  include.mean = TRUE)
}
\arguments{
\item{m1}{an ARIMA time series model object.}

\item{rt}{the time series.}

\item{orig}{forecast origin.}

\item{h}{forecast horizon.}

\item{xre}{the independent variables.}

\item{fixed}{parameter constraint.}

\item{include.mean}{a logical value for constant term of the model. Default is TRUE.}
}
\value{
The function returns a list with following components:
\item{orig}{the starting forecast origin.}
\item{err}{observed value minus fitted value.}
\item{rmse}{RMSE of out-of-sample forecasts.}
\item{mabso}{mean absolute error of out-of-sample forecasts.}
\item{bias}{bias of out-of-sample forecasts.}
}
\description{
Backtest for an ARIMA time series model.
}
\examples{
data=arima.sim(n=100,list(ar=c(0.5,0.3)))
model=arima(data,order=c(2,0,0))
backtest(model,data,orig=70,h=1)
}
