% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Sstep.Smooth.Sonar}
\alias{Sstep.Smooth.Sonar}
\title{Sequential Importance Sampling for A Target with Passive Sonar}
\usage{
Sstep.Smooth.Sonar(mm, xxt, xxt1, ww, vv, par)
}
\arguments{
\item{mm}{the Monte Carlo sample size \code{m}.}

\item{xxt}{the sample in the last iteration.}

\item{xxt1}{the sample in the next iteration.}

\item{ww}{the forward filtering weight.}

\item{vv}{the backward smoothing weight.}

\item{par}{a list of parameter values. \code{H} is the state coefficient matrix, and \code{W*t(W)} is the state innovation covariance matrix.}
}
\value{
The function returns a list with the following components:
\item{xx}{the new sample.}
\item{logww}{the log weights.}
}
\description{
This function uses the sequential importance sampling method to deal with a target with passive sonar for smoothing.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
