% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{g_cfar2}
\alias{g_cfar2}
\title{Generate a CFAR(2) Process}
\usage{
g_cfar2(
  tmax = 1001,
  rho = 5,
  phi_func1 = NULL,
  phi_func2 = NULL,
  grid = 1000,
  sigma = 1,
  ini = 100
)
}
\arguments{
\item{tmax}{length of time.}

\item{rho}{parameter for O-U process (noise process).}

\item{phi_func1}{the first convolutional function. Default is 0.5*x^2+0.5*x+0.13.}

\item{phi_func2}{the second convolutional function. Default is 0.7*x^4-0.1*x^3-0.15*x.}

\item{grid}{the number of grid points used to construct the functional time series. Default is 1000.}

\item{sigma}{the standard deviation of O-U process. Default is 1.}

\item{ini}{the burn-in period.}
}
\value{
The function returns a list with components:
\item{cfar2}{a tmax-by-(grid+1) matrix following a CFAR(1) process.}
\item{epsilon}{the innovation at time tmax.}
}
\description{
Generate a convolutional functional autoregressive process with order 2.
}
\examples{
phi_func1= function(x){
return(0.5*x^2+0.5*x+0.13)
}
phi_func2= function(x){
return(0.7*x^4-0.1*x^3-0.15*x)
}
y=g_cfar2(1000,5,phi_func1,phi_func2,grid=1000,sigma=1,ini=100)
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
