% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.est}
\alias{uTAR.est}
\title{General Estimation of TAR Models}
\usage{
uTAR.est(
  y,
  arorder = c(1, 1),
  thr = c(0),
  d = 1,
  thrV = NULL,
  include.mean = c(TRUE, TRUE),
  output = TRUE
)
}
\arguments{
\item{y}{time series.}

\item{arorder}{AR order of each regime. The number of regime is the length of arorder.}

\item{thr}{given threshold(s). There are k-1 threshold for a k-regime model.}

\item{d}{delay for threshold variable, default is 1.}

\item{thrV}{external threshold variable if any. If it is not NULL, thrV must have the same length as that of y.}

\item{include.mean}{a logical value indicating whether constant terms are included. Default is TRUE.}

\item{output}{a logical value for output. Default is TRUE.}
}
\value{
uTAR.est returns a list with components:
\item{data}{the data matrix, y.}
\item{k}{the number of regimes.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{coefs}{a k-by-(p+1) matrices, where \code{k} is the number of regimes. The i-th row shows the estimation results in regime i.}
\item{sigma}{estimated innovational covariances for all the regimes.}
\item{thr}{threshold value.}
\item{residuals}{estimated innovations.}
\item{sresi}{standardized residuals.}
\item{nobs}{numbers of observations in different regimes.}
\item{delay}{delay for threshold variable.}
\item{cnst}{logical values indicating whether the constant terms are included in different regimes.}
\item{AIC}{AIC value.}
}
\description{
General estimation of TAR models with known threshold values.
It perform LS estimation of a univariate TAR model, and can handle multiple regimes.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))
thr.est=uTAR.grid(y=y$series, p1=2, p2=2, d=2, thrQ=c(0,1),Trim=c(0.1,0.9))
est=uTAR.est(y=y$series, arorder=c(2,2), thr=thr.est$thr, d=2)
}
