% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PM.test.R
\name{PM.test}
\alias{PM.test}
\title{Test of independence between marks and points of a stationary marked point process}
\usage{
PM.test(X, R, R.variogram)
}
\arguments{
\item{X}{marked point pattern dataset (object of class \code{ppp})}

\item{R}{positive real number determining the domain for the (marked) K-function used for computing the test statistic}

\item{R.variogram}{positive real number determining the domain for variogram estimation}
}
\value{
The p-value of the test of independence between marks and points of a stationary marked point process.
}
\description{
Test of independence between marks and points of a stationary marked point process
based on the comparison of the mark K-function and the K-function of the underlying point process,
see Guan (2006).
}
\details{
The test was proposed in Guan (2006) and used in Dvořák et al. (2022) as one of the tools 
to determine the dependence structure between points, marks and a covariate in a marked point process setting.
The marked point process is assumed to be stationary here.

The observed marked point pattern should be supplied using the argument \code{X}.
The upper limit of the domain for the (marked) K-function used for constructing the test statistic
is given by the argument \code{R}. Furthermore, the variance used for constructing 
the test statistic is determined using a fitted covariance model for the mark field.
In the given implementation, the exponential model for the covariance is assumed.
The model parameters are estimated by fitting the corresponding parametric model
to the empirical variogram by the least-squares approach, with the upper bound on
the variogram argument given by \code{R.variogram}.
}
\examples{

library(spatstat)
library(geoR)

set.seed(123)

X <- rpoispp(100)
X <- X \%mark\% runif(n=X$n)

out <- PM.test(X, R=0.1, R.variog=1)
out

}
\references{
Y. Guan (2006): Tests for independence between marks and points of a marked point Process. Biometrics 62, 126-134.

J. Dvořák, T. Mrkvička, J. Mateu, J.A. González (2022): Nonparametric testing of the dependence structure among points-marks-covariates in spatial point patterns. International Statistical Review 90(3), 592-621.
}
