% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual_information_condition.R
\name{mutual.information.condition}
\alias{mutual.information.condition}
\title{Tests how much each element increases the specificity of all combinations it is in}
\usage{
mutual.information.condition(netfacs.data)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}
}
\value{
Function returns a list with two data frames that include all elements and first-order combinations that occur at all, the number of combinations that each element/combination is part of, and how much adding this element to a combination adds on average to its specificity, and how often it occurs
}
\description{
The function takes all elements and dyadic combinations of elements in a netfacs object, goes through all combinations these elements are in, and compares the specificity (strength with which the combination identifies the test condition) of all combinations with the element and the same combinations without the element, to test how much specificity the element adds when added to a signal. Only works for netfacs objects based on comparison between conditions.
}
\examples{
### how do angry facial expressions differ from non-angry ones?
\donttest{
data(emotions_set)
angry.face <- netfacs(
 data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  null.condition = NULL,
  ran.trials = 100,
  combination.size = 4
)

head(mutual.information.condition(angry.face), 20)
}
}
