% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{randomXcor}
\alias{randomXcor}
\alias{randomXcor,worldNLR,numeric-method}
\title{Random \code{xcor}}
\usage{
randomXcor(world, n)

\S4method{randomXcor}{worldNLR,numeric}(world, n)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{n}{Integer.}
}
\value{
Numeric. Vector of length \code{n} of \code{xcor} coordinates.
}
\description{
Report \code{n} random \code{xcor} coordinates within the \code{world}'s extent.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createTurtles(n = 10, coords = cbind(xcor = randomXcor(world = w1, n = 10),
                                           ycor = randomYcor(world = w1, n = 10)))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#random-cor}
}
\author{
Sarah Bauduin
}
