% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{of}
\alias{of}
\alias{of,missing,agentMatrix,character-method}
\alias{of,worldMatrix,matrix,missing-method}
\alias{of,worldArray,matrix,character-method}
\title{Values of an \code{agents} variable}
\usage{
of(world, agents, var)

\S4method{of}{missing,agentMatrix,character}(agents, var)

\S4method{of}{worldMatrix,matrix,missing}(world, agents)

\S4method{of}{worldArray,matrix,character}(world, agents, var)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{var}{Character. Vector of the names of the selected \code{agents} variables.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a
\code{worldArray} object, \code{var} is the name of the layers to
use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is some of
the \code{turtles}' variable and can be any of the variables created
when \code{turtles} were created,
as well as any variable created with \code{turtlesOwn()}.}
}
\value{
Vector of values for the \code{agents} if one variable is
requested. The class depends
of the variable class. The order of the vector follows the order
of the \code{agents}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Matrix or `Dataframe` (`ncol` = `length(var)`, `nrow` = `NLcount(agents)`)
    if more than one variable is requested. The row order
    follows the order of the `agents`.
}\if{html}{\out{</div>}}
}
\description{
Report the \code{agents} values for the requested variable.
}
\details{
\code{world} must be provided only if \code{agents} are \code{patches}.
}
\examples{
# Patches
w1 <- createWorld(
  minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
  data = 1:25
)
of(world = w1, agents = patch(w1, c(0, 0), c(4, 0)))

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
of(agents = t1, var = "heading")

}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#of}
}
\author{
Sarah Bauduin
}
