% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.mmsbm.R
\name{simulate.mmsbm}
\alias{simulate.mmsbm}
\title{Simulate a complete sociomatrix from an \code{mmsbm} object}
\usage{
\method{simulate}{mmsbm}(object, nsim = 1, seed = NULL,
  new.data.dyad = NULL, new.data.monad = NULL, parametric_mm = FALSE,
  ...)
}
\arguments{
\item{object}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}}

\item{nsim}{Number of networks to simulate}

\item{seed}{RNG seed.}

\item{new.data.dyad}{An optional \code{data.frame} object. If not \code{NULL}, use these 
dyadic predictor values instead of those used to fit the original model.}

\item{new.data.monad}{An optional \code{data.frame} object. See \code{new.data.dyad}.}

\item{parametric_mm}{Boolean. Should the variational posterior be used for sampling the mixed-memberships (\code{FALSE}), 
or should the mixed-meberships be formed using the parameters in the monadic regression equation (\code{TRUE})?
Defaults to \code{FALSE}. If \code{is.null(new.data.monad)=FALSE}, setting this to \code{FALSE} will produce an error.}

\item{...}{Currently ignored}
}
\value{
List of length \code{nsim} of simulated networks. 
        If \code{new.data.dyad = NULL}, each element is a vector of length \code{nrow(object$dyadic.data)}. 
        Else, vector of length \code{nrow(new.data.dyad)}. If \code{seed} is not NULL, return object
        includes its value as attribute "seed". .
}
\description{
The function generates one sample network from the posterior predictive of the model represented by a fitted \code{mmsbm} object.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
set.seed(123)
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2)

## Simulate 5 new networks
lazega_sim <- simulate(lazega_mmsbm, nsim = 5, seed = 123)

}
\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
