% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mmsbm.R
\name{plot.mmsbm}
\alias{plot.mmsbm}
\title{Various visualization tools for 'mmsbm' objects}
\usage{
\method{plot}{mmsbm}(x, type = "groups", FX = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}.}

\item{type}{character string denoting the type of plot. The default, "\code{groups}," plots the estimated matrix of 
group by group edge formation probabilities as a network plot, with nodes representing groups (sized proportional to relative membership) 
and edge colors encoding probability of between-group ties. "\code{blockmodel}" plots the same information,
but using a tile plot instead of a network plot.  "\code{membership}" plots average membership in
each latent group by time period. "\code{effect}" provides a series of plots showing the estimated effect 
of a shfit in monadic covariate values.}

\item{FX}{with \code{type == "effect"}; a list resulting from a call to \code{covFX}.}

\item{...}{Currently ignored}
}
\value{
The requested plot object.
}
\description{
The function provides a variety of plotting options for a fitted \code{mmsbm} object.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2,
                      mmsbm.control = list(seed = 123,
                                           hessian = FALSE))

## Plot blockmodel as network
plot(lazega_mmsbm)

}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aaylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
