#' Major Power Alliance Network (1816 - 2012)
#'
#' This dataframe contains major power alliance network data from 1816 to 2012 (2 year interval).
#'
#' @name MajorAlly
#'
#' @docType data
#'
#' @format The dataframe has contains data for major power alliance network data
#' from 1816 to 2012. Major power definition is the COW data set, which incldues
#' USA, UK, France, Germany (West Germany during 1954-1989), Austria, Italy,
#' Russia, China, and Japan. In this data set, a defense pact (Type I),
#' which is the highest level of military commitment, is coded as 1,
#' and 0 otherwise. 
#'
#' @source Correlates of War Project. 2017. "State System Membership List,
#' v2016." Online, \url{http://correlatesofwar.org}.
#' Gibler, Douglas M. 2009. \emph{International military alliances, 1648-2008.}
#' CQ Press.  
#'
#' @keywords datasets
NULL

#' Postwar Alliance Network (1846 - 2012)
#'
#' This dataframe contains postwar alliance network data from 1946 to 2012 (2 year interval).
#'
#' @name PostwarAlly
#'
#' @docType data
#'
#' @format The dataframe has contains data for postwar alliance network data
#' from 1946 to 2012 with 2 year interval. After removing disconnected components,
#' 104 countries are included. In this data set, a defense pact (Type I),
#' which is the highest level of military commitment, is coded as 1,
#' and 0 otherwise. 
#'
#' @source Correlates of War Project. 2017. "State System Membership List,
#' v2016." Online, \url{http://correlatesofwar.org}.
#' Gibler, Douglas M. 2009. \emph{International military alliances, 1648-2008.}
#' CQ Press.  
#'
#' @keywords datasets
NULL
