% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{ECOplusMaST}
\alias{ECOplusMaST}
\title{ECO+MaST Network Filter}
\usage{
ECOplusMaST(data, weighted = TRUE, binary = FALSE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{weighted}{Should network be weighted? Defaults to TRUE. Set FALSE to produce an unweighted (binary) network}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}
}
\value{
A sparse association matrix
}
\description{
Applies the ECO neural network filtering method combined with the MaST filtering method
}
\examples{
weighted_ECOplusMaSTnetwork<-ECOplusMaST(data)

weighted_binary_ECOplusMaSTnetwork<-ECOplusMaST(data,binary=TRUE)

unweighted_binary_ECOplusMaSTnetwork<-ECOplusMaST(data,weighted=FALSE)

unweighted_binary_ECOplusMaSTnetwork<-ECOplusMaST(data,binary=TRUE,weighted=FALSE)
}
\references{
Fallani, F. D. V., Latora, V., & Chavez, M. (2017).
A topological criterion for filtering information in complex brain networks.
PLoS Computational Biology, 13(1), e1005305.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
