% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{ECO}
\alias{ECO}
\title{ECO Neural Network Filter}
\usage{
ECO(data, weighted = TRUE, binary = FALSE, directed = FALSE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{weighted}{Should network be weighted? Defaults to TRUE. Set FALSE to produce an unweighted (binary) network}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{directed}{Is the network directed? Defaults to FALSE. Set TRUE if the network is directed}
}
\value{
A sparse association matrix
}
\description{
Applies the ECO neural network filtering method
}
\examples{
weighted_undirected_ECOnetwork<-ECO(hex)

unweighted_undirected_ECOnetwork<-ECO(hex,weighted=FALSE)

weighted_directed_ECOnetwork<-ECO(hex,directed=TRUE)

unweighted_directed_ECOnetwork<-ECO(hex,weighted=FALSE,directed=TRUE)

weighted_undirected_binary_ECOnetwork<-ECO(hexb,binary=TRUE)

unweighted_undirected_binary_ECOnetwork<-ECO(hexb,weighted=FALSE,binary=TRUE)

weighted_directed_binary_ECOnetwork<-ECO(hexb,directed=TRUE,binary=TRUE)

unweighted_directed_binary_ECOnetwork<-ECO(hexb,weighted=FALSE,directed=TRUE,binary=TRUE)
}
\references{
Fallani, F. D. V., Latora, V., & Chavez, M. (2017).
A topological criterion for filtering information in complex brain networks.
\emph{PLoS Computational Biology}, \emph{13}(1), e1005305.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
