% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{edgerep}
\alias{edgerep}
\title{Edge Replication}
\usage{
edgerep(A, B)
}
\arguments{
\item{A}{An adjacency matrix of network A}

\item{B}{An adjacency matrix of network B}
}
\value{
Returns a list of the number of edges that replicate (replicated),
total number of edges (possibleA & possibleB),
the percentage of edges that replicate (percentageA & percentageB),
the density of edges (densityA & densityB),
the mean difference between edges that replicate (meanDifference),
the sd of the difference between edges that replicate (sdDifference),
and the correlation between the edges that replicate for both networks (correlation)
}
\description{
Computes the number of edges that replicate between two cross-sectional networks
}
\examples{
A<-TMFG(hex)$A

B<-MaST(hex)

edges<-edgerep(A,B)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
