% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{louvain}
\alias{louvain}
\title{Louvain Community Detection Algorithm}
\usage{
louvain(A, gamma, M0, method = c("modularity", "potts"))
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{gamma}{Defaults to 1.
Set to gamma > 1 to detect smaller modules and gamma < 1 for larger modules}

\item{M0}{Input can be an initial community vector.
Defaults to none}

\item{method}{Defaults to "modularity".
Set to "potts" for Potts model}
}
\value{
Returns a list of community and Q
}
\description{
Computes a vector of communities (community) and a global modularity measure (Q)
}
\examples{
A<-TMFG(hex)$A

modularity<-louvain(A)
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks. 
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.
 
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
