% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{participation}
\alias{participation}
\title{Participation Coefficient}
\usage{
participation(A, factors = c("walktrap", "louvain"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{factors}{A vector of corresponding to each item's factor.
Defaults to "walktrap" for the walktrap community detection algorithm.
Set to "louvain" for the louvain community detection algorithm.
Can also be set to user-specified factors (see examples)}
}
\value{
Returns a list of overall (signs not considered; overall),
negative (negative), and positive (positive) participation coefficient.
Values closer to 1 suggest greater within-community connectivity and 
values closer to 0 suggest greater between-community connectivity
}
\description{
Computes the participation coefficient for each node. The participation
coefficient measures the strength of a node's connections within its community. Positive
and negative signed weights for participation coefficients are computed separately.
}
\examples{
#theoretical factors
factors <- c(rep(1,8), rep(2,8), rep(3,8), rep(4,8), rep(5,8), rep(6,8))

A <- TMFG(neoOpen)$A

pc <- participation(A, factors = factors)

#walktrap factors
wpc <- participation(A, factors = "walktrap")
}
\references{
Guimera, R., & Amaral, L. A. N. (2005).
Functional cartography of complex metabolic networks.
\emph{Nature}, \emph{433}(7028), 895-900.

Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
